# twitch_proxy_config
class twitch_proxy_config (
  $http_proxy = $twitch_proxy_config::params::http_proxy,
  $no_proxy   = $twitch_proxy_config::params::no_proxy
) inherits twitch_proxy_config::params {

  validate_string($http_proxy)
  validate_array($no_proxy)

  include twitch_vars

  $proxy_ensure = str2bool($::proxy_needed) ? {
    true    => 'present',
    default => 'absent'
  }

  $_no_proxy = concat($no_proxy,$::twitch_vars::twitch_networks)

  file { '/etc/apt/apt.conf.d/95proxy':
    ensure  => $proxy_ensure,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template("${module_name}/aptproxy.conf.erb"),
    before  => Exec['apt_update'],
  }

  file { '/usr/local/sbin/proxy_config.sh':
    ensure  => 'present',
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    content => template("${module_name}/proxy_config.sh.erb"),
  }

  systemd::service {'proxy_config':
    description       => 'Twitch Proxy Config',
    after_units       => ['team-wait-online.service'],
    wants             => ['team-wait-online.service'],
    execstart         => '/usr/local/sbin/proxy_config.sh',
    type              => 'oneshot',
    restart           => 'no',
    remain_after_exit => true,
    syslog_identifier => 'proxy_config',
    standard_output   => 'syslog',
    standard_error    => 'syslog',
    wantedby          => ['network-online.target'],
    require           => File['/usr/local/sbin/proxy_config.sh'],
  }

  service {'proxy_config':
    ensure    => 'running',
    enable    => true,
    require   => Systemd::Service['proxy_config'],
    subscribe => File['/usr/local/sbin/proxy_config.sh'],
  }

}
