# Twitch Puppet Module

#### Table of Contents
<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
## Overview

- [Overview](#overview)
- [Module Description](#module-description)
- [Setup](#setup)
  - [What twitch_puppet affects](#what-twitch_puppet-affects)
  - [Beginning with twitch_puppet](#beginning-with-twitch_puppet)
- [Usage](#usage)
  - [Class twitch_puppet parameters](#class-twitch_puppet-parameters)
- [Reference](#reference)
  - [Classes](#classes)
  - [Defines](#defines)
- [Limitations](#limitations)
- [Contribution](#contribution)
  - [Making Changes](#making-changes)
  - [Pull Requests](#pull-requests)
  - [Code Reviews](#code-reviews)
- [Release Notes/Contributors/Etc **Optional**](#release-notescontributorsetc-optional)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->
## Overview

Manages puppet agent

## Module Description

Module installs Puppet and configures the machine to become a remote puppet agent, or a puppet master.

## Setup

### Configuration

There are a few usages of this module:

To install/configure puppet and point it at our puppet masters:

    include twitch_puppet

To install/configure puppet to be a puppet master, first set `puppet_master:
true` in hiera for the node or cluster, then:

    include twitch_puppet


##### Puppetmaster setup

When bringing up a puppetmaster with this module, assuming you're using the minimal
config and want it to work on a PoPmaster (`twitch_puppet::master: true`), using
our existing puppet CA, it will:

1. Generate a new CSR and submit it to our CA.
    * This certificate _cannot_ be automatically
      signed because it contains DNS alt names, so you must manually sign it. To
      do that, SSH to `puppet-ca.internal.justin.tv` and `puppet cert --allow-dns-alt-names sign hostname.tv`.

      There's a small helper script already running on your new puppetmaster
      which is just waiting for the cert to be signed. Once that's done, the helper
      will automatically restart the services that failed to start without a cert.

2. Generate an SSH key for the `puppet` user.
    * This SSH needs to be submitted to GitHub for automatic deploys to work, so
      puppet will run a script at `/opt/twitch/puppetmaster_github_setup.sh` which
      requires a set of github credentials in the file `/var/lib/puppet/github_pass`.

      That file should look like:

          GITHUB_USERNAME=yourgithubusername
          GITHUB_PASSWORD="yourgithubpassword"

      The script will first upload the new public key, then create a webhook pointing
      back at your new puppetmaster.

3. Clone the current puppet repo into `/etc/puppet/environments/master`, assuming
   the SSH key was uploaded in the previous step. If your `github_pass` file wasn't
   available during your first run, put it in place and run puppet again so that
   this module can clone the repository.

##### Puppet CA

To configure a single puppet master server as a Certificate Authority (CA), you
would add the following to hiera:

    puppet_master: true
    puppet_ca: true


### Puppet Certificate Instructions

The server portion of this module attempts to setup a puppet master without
trying to muck with the certificates, in case you wanted to manually port over
existing SSL certificates. This means that if you're setting up a puppet CA
from scratch with no intention of migrating, you'll need to do some manual
things to setup the certificates correctly.

A few things to consider:

* PuppetCA runs on 1 server only.
* PuppetCA is only queried directly for first run certificate request/signing.


Steps to create first certs:

* Generate a master cert with puppetca in DNS alt names

    $ puppet cert list
    Notice: Signed certificate request for ca

3.




### UPDATED

  puppetmaster apt package from puppetlabs setups new certificates


### What twitch_puppet affects

* /etc/puppet/puppet.conf

### Beginning with twitch_puppet

## Usage

```
include twitch_puppet

```
hiera
```
twitch_puppet::agent::service::puppet_run_style: cron
```

### Class twitch_puppet parameters

* twitch_puppet::ca_certs
  * certs
* twitch_puppet::external_facts
  * facter_facts_d
* twitch_puppet::master
  * puppet_master_package
  * puppet_master_version
  * bootstrap
  * ca
  * puppetdb_server
  * puppet_ca_server
  * puppet_server
* twitch_puppet
  * puppet4
  * master
  * puppet_ca_server
  * puppet_agent_ensure
* twitch_puppet::config
  * puppet_group
  * puppet_user
  * puppet_confdir
  * puppet_conf
* twitch_puppet::agent::metrics
  * enable
  * diamond_collector_opts
* twitch_puppet::agent::service
  * puppet_run_style
  * puppet_run_interval
  * puppet_run_command
* twitch_puppet::agent::p5_install
  * enable_cron
* twitch_puppet::agent::install
  * puppet_agent_ensure
  * puppet_agent_package
* twitch_puppet::agent::config
  * puppet_env
  * splay
  * daemonize
  * puppet_conf
  * puppet_logdir
  * puppet_run_interval
  * puppet_ca_server
  * puppet_server
* twitch_puppet::agent (
  * puppet_ca_server
  * puppet_server
  * puppet_agent_package
  * puppet_agent_ensure
* twitch_puppet::master::monitoring (
  * unicorn_pidfile
  * puppet_rackdir
  * puppet_user
  * puppet_group
  * monit_mem_max
* twitch_puppet::master::puppetdb (
  * puppetdb_server
* twitch_puppet::master::install (
  * puppet_master_package
  * puppet_master_version
  * puppet_master_ensure
  * puppetdb_server
  * puppet_ca_server
  * puppet_server
  * puppet_confdif
  * ca
  * puppet_unicorn_socket
  * puppet_ssldir
* twitch_puppet::master::config (
  * puppet_user
  * puppet_group
  * puppet_vardir
  * puppet_confdir
  * puppet_ssldir
  * puppet_environment_dir
  * puppet_production_link
  * puppet_conf
  * puppet_certname
  * puppet_pidfile
  * puppet_rackdir
  * puppet_unicorn_pidfile
  * puppet_unicorn_socket
  * git_server
  * git_project
  * puppet_server
  * puppet_ca_server
  * puppet_logdir
  * dns_alt_names
  * environmentpath
  * modulepath
  * manifest
  * templatedir
  * hiera_config
  * reports
  * environments
  * reporturl
  * external_nodes
  * node_terminus
  * always_cache_features
  * strict_variables
  * trusted_node_data
  * ca
  * bootstrap
* twitch_puppet::master::logging (
  * log_output_tag

## Reference

### Classes

* twitch_puppet
* twitch_puppet::ca_certs
* twitch_puppet::external_facts
* twitch_puppet::master
* twitch_puppet::config
* twitch_puppet::agent::metrics
* twitch_puppet::agent::service
* twitch_puppet::agent::p5_install
* twitch_puppet::agent::install
* twitch_puppet::agent::config
* twitch_puppet::agent
* twitch_puppet::master::monitoring
* twitch_puppet::master::service
* twitch_puppet::master::puppetdb
* twitch_puppet::master::install
* twitch_puppet::master::config
* twitch_puppet::master::logging


### Defines
* twitch_puppet::ca_certs::cert
  * user
  * group

## Limitations

## Contribution

### Making Changes

Contributions to this repository:

* need to be limited to what is described in [Module Description](#module-description).
  * Not doing so has created massive tech debt in the past, which lead to another massive cleanup still in progress (deprecation of the core module).
* should be reviewed via [Pull Requests](#pull-requests) before merging.
* must follow the [Code Contribution Guidelines].
* See the [Code Contribution Checklist] for a quick reference.
* Any changes outside of the scope should follow puppet best pratices and be included either by role or service module. e.g.

Add to classes in either environment or cluster in video-puppet/hiera_data
```
# environment/canary/video-tier1.yaml
---
classes:
  - twitch_random_service_modules
  - additional_module_1
  - additional_module_2
```
or

Add include in the service class
    edit video-tier1/manifests/init.pp or appropriate sub class in the module and include:
```
include additional_module_1
include additional_module_2
```

### Pull Requests
All pull requests must:
  - Have a description explaining the problem
  - Snippet of any output error
  - Snippet of any output showing the fixed results
  - Contain a link to a JIRA ticket
  - Have been linted:
   - `puppet-lint`
   - `flake8`
   - `puppet validate`
   - etc
  - Not contain lint errors. Run all new code through `puppet-lint`.

### Code Reviews

PR reviews require video core services approval before merging. If you need help finding a reviewer, ping the [#video-coreservices] Slack channel.

Contributions need to be limited to what is described in Module Description. Not doing so has created massive tech debt in the past, which lead to another massive cleanup still in progress (deprecation of the core module). Any changes outside of the scope should follow puppet best pratices and be included either by role or service module. e.g.

Add to classes in either environment or cluster in video-puppet/hiera_data
```
# environment/canary/video-tier1.yaml
---
classes:
  - twitch_random_service_modules
  - additional_module_1
  - additional_module_2
```
or

Add include in the service class
    edit video-tier1/manifests/init.pp or appropriate sub class in the module and include:
```
include additional_module_1
include additional_module_2
```

## Release Notes/Contributors/Etc **Optional**

[#video-coreservices]: https://twitch.slack.com/messages/CEVFAMMLH/
[Code Contribution Guidelines]: https://wiki.xarth.tv/display/VID/Puppet+Usage+Guidance+-+Video+Platform
[Code Contribution Checklist]: https://wiki.xarth.tv/display/VID/Puppet+Usage+Guidance+-+Video+Platform#PuppetUsageGuidanceVideoPlatform-GeneralGuidance
