#!/usr/bin/env python
# physicalprocessorrange = list of non hyperthreaded cores
# siblingprocessorrange  = list of hyperthreaded cores
import glob

physical_processor_range = []
sibling_processor_range = []
sibling_range = ''

for cpu in glob.glob('/sys/devices/system/cpu/cpu*/topology/core_siblings_list'):
  with open (cpu,'r') as filename:
    ranges = filename.read().split(',')
    physical_range = ranges[0].rstrip()
    if len(ranges) == 2:
      sibling_range = ranges[1]
    #physical_range,sibling_range = filename.read().split(',')
    physical_processor_range.append(physical_range.rstrip())
    sibling_processor_range.append(sibling_range.rstrip())

physical_processor_range = sorted(set(physical_processor_range))
sibling_processor_range = sorted(set(sibling_processor_range))

print 'physicalprocessorrange=' + ",".join(physical_processor_range)
if sibling_range:
  print 'siblingprocessorrange=' + ",".join(sibling_processor_range)

