#!/usr/bin/env python

import re
try:
    from pynetlinux import ifconfig
except:
    print "No pynetlinux module installed"
    exit(0)

def main ():
    speed_list = {}
    physical_interfaces = ifconfig.list_ifs()
    for interface in physical_interfaces:
        try:
            speed = interface.get_link_info()[0]
            speed_list[interface.name] = speed
        except:
            continue

    bond_interfaces = ifconfig.list_ifs(False)
    bond_string = re.compile('^bond\d+$')

    for interface in bond_interfaces:
        if bond_string.match(interface.name):
            bond_slave_file = '/sys/class/net/' + interface.name + '/bonding/slaves'
            with open(bond_slave_file) as tmp:
                bond_slaves = tmp.read().split()
            bond_speed = 0
            for slave in bond_slaves:
                try:
                    bond_speed += speed_list[slave]
                    speed_list[interface.name] = bond_speed
                except:
                    continue

    if bool(speed_list):
        speed_list['max_nic'] = speed_list[max(speed_list,key=speed_list.get)]

    for i in speed_list:
        print "%s_speed=%s" % (i,speed_list[i])


if __name__ == "__main__":
    main()
