#!/usr/bin/python
import collections
import subprocess
import re
import glob
import hashlib
try:
    import json
except:
    print "No json module installed"
    exit(1)

try:
    import dmidecode
except:
    print "No dmidecode module installed"
    exit(1)

memory = dmidecode.memory()
memory_list = {}
processor = dmidecode.processor()
processor_list = {}
motherboard = dmidecode.baseboard()
motherboard_list = {}
integrator = dmidecode.system()
integrator_list = {}
network_list = {}
lspci_output = subprocess.check_output('/usr/bin/lspci')
controller_list = {}
drive_list = {}
network_count = processor_count = controller_count = memory_count = 0

memory_ordered = collections.OrderedDict(sorted(memory.items()))
sku_list = {}

dmidecode.clear_warnings()

for key, val in memory_ordered.items():
    try:
        if 'MHz' in memory[key]['data']['Speed']:
            content = {'manufacturer': memory[key]['data']['Manufacturer'].strip(' '),
                       'size': memory[key]['data']['Size'],
                       'part number': memory[key]['data']['Part Number'],
                       'speed': memory[key]['data']['Speed']}
            memory_list.update({memory_count: content})
            memory_count += 1
    except:
        continue

for key, val in processor.items():
    try:
        content = {'processor': processor[key]['data']['Version'],
                   'core count': processor[key]['data']['Core Count'],
                   'thread count': processor[key]['data']['Thread Count']}
        processor_list.update({processor_count: content})
        processor_count += 1
    except:
        continue

for key, val in motherboard.items():
    try:
        motherboard_list.update({'manufacturer': motherboard[key]['data']['Manufacturer']})
        motherboard_list.update({'product name': motherboard[key]['data']['Product Name']})
    except:
        continue


for key, val in integrator.items():
    try:
        integrator_list.update({'integrator': integrator[key]['data']['Manufacturer']})
        integrator_list.update({'product name': integrator[key]['data']['Product Name']})
        integrator_list.update({'sku number': integrator[key]['data']['SKU Number']})
    except:
        continue

for controller in lspci_output.split('\n'):
    if re.search('(RAID bus|Serial Attached SCSI|SATA) controller:', controller):
        content = controller.split(':')[2].lstrip(' ')
        controller_list.update({controller_count: content})
        controller_count += 1

for network in lspci_output.split('\n'):
    if re.search('Ethernet controller:', network):
        network_list.update({network_count: network.split(':')[2].lstrip(' ')})
        network_count += 1


search_path = '/sys/class/block/sd*/device/model'
for index, socket_path in enumerate(glob.glob(search_path)):
    model = open(socket_path, 'r').read().splitlines()
    drive_list.update({index: model[0]})

sku_list.update({'controller': controller_list})
sku_list.update({'drive': drive_list})
sku_list.update({'integrator': integrator_list})
sku_list.update({'memory': memory_list})
sku_list.update({'motherboard': motherboard_list})
sku_list.update({'network': network_list})
sku_list.update({'processor': processor_list})

sku_json = json.dumps(sku_list, sort_keys=True)

print ('sku={}').format(sku_json)
print ('sku_hash={}').format(hashlib.md5(sku_json).hexdigest())
