# puppet_ssldir.rb
# Returns the current ssldir setting for the running puppet agent. We need this
# for some modules that want to use puppet's certificate for authentication.

Facter.add('puppet_ssldir') do
  # puppetlabs-stdlib provides puppet_vardir, which loads some code we need to
  # leverage to get the ssldir.
  confine :puppet_vardir => /^.+$/
  setcode do
    # This will be nil if Puppet is not available.
    Facter::Util::PuppetSettings.with_puppet do
      Puppet[:ssldir]
    end
  end
end
