# sets up puppet agent config files
class twitch_puppet::agent::config (
  $puppet_env          = 'production',
  $splay               = false,
  $daemonize           = false,
  $puppet_conf         = $twitch_puppet::params::puppet_conf,
  $puppet_logdir       = $twitch_puppet::params::puppet_logdir,
  $puppet_run_interval = $twitch_puppet::params::puppet_run_interval,
  $puppet_ca_server    = $twitch_puppet::params::puppet_ca_server,
  $puppet_server       = $twitch_puppet::params::puppet_server,
) inherits twitch_puppet::params {
  include twitch_puppet::agent

  # Validate things
  validate_bool($splay, $daemonize)
  validate_string($puppet_env, $puppet_ca_server, $puppet_server)
  validate_absolute_path($puppet_conf, $puppet_logdir)
  validate_integer($puppet_run_interval)

  # override local ini_setting resources
  Ini_setting {
    path    => $puppet_conf,
    section => 'agent',
    notify  => Service['puppet'],
    require => File[$puppet_conf],
  }

  ini_setting { 'puppet_ca_server':
    section => 'main',
    setting => 'ca_server',
    value   => $puppet_ca_server,
  }

  ini_setting { 'puppet_logdir':
    section => 'main',
    setting => 'logdir',
    value   => $puppet_logdir,
  }

  ini_setting { 'puppet_trusted_nodedata':
    ensure  => present,
    section => 'main',
    setting => 'trusted_node_data',
    value   => true,
  }

  ini_setting { 'puppet_stringify_facts':
    ensure  => present,
    section => 'main',
    setting => 'stringify_facts',
    value   => false,
  }

  # needs to be set in main
  ini_setting { 'puppetagent_ca_server':
    ensure  => 'absent',
    setting => 'ca_server',
  }

  ini_setting { 'puppetagent_server':
    setting => 'server',
    value   => $puppet_server,
  }

  $puppetagent_environment = $::puppet_environment ? {
    undef   => $puppet_env,
    default => $::puppet_environment,
  }

  ini_setting { 'puppetagent_environment':
    setting => 'environment',
    value   => $puppetagent_environment,
  }

  # Sets this to 30mins if run_interval=30 (should be)
  ini_setting { 'puppetagent_runinterval':
    setting => 'runinterval',
    value   => $puppet_run_interval * 60,
  }

  ini_setting { 'puppetagent_splay':
    setting => 'splay',
    value   => $splay,
  }

  ini_setting { 'puppetagent_daemonize':
    setting => 'daemonize',
    value   => $daemonize,
  }
}
