# puppet agent metrics
class twitch_puppet::agent::metrics (
  $enable                 = true,
  $diamond_collector_opts = $twitch_puppet::params::diamond_collector_opts,
) inherits twitch_puppet::params {
  include twitch_puppet::agent

  validate_bool($enable)
  validate_hash($diamond_collector_opts)

  # Only include on live baremetal machines
  if $facts['machine_type'] == 'baremetal' {
    twitch_diamond::collector { 'PuppetAgentCollector':
      enable  => $enable,
      source  => true,
      options => $diamond_collector_opts,
    }

    # Hacky fix for overriding default puppet collector with ours (ie: remove it)
    file { "${::twitch_diamond::diamond_collectors_d}/puppetagent/":
      ensure => 'absent',
      force  => true,
      notify => Class['twitch_diamond::service'],
    }
  }
}
