# Installs the puppet5 agent without disturbing puppet3 agent
# optionally sets up daily cron job for p5 noop runs
class twitch_puppet::agent::p5_install (
  $enable_cron = false,
) {

  package { 'puppet-agent':
    ensure => installed,
  }

  exec { 'copy_puppet5_ssl':
    command => 'cp -rdp /etc/puppet/ssl /etc/puppetlabs/puppet/ || cp -rdp /var/lib/puppet/ssl /etc/puppetlabs/puppet/',
    creates => '/etc/puppetlabs/puppet/ssl/certs/ca.pem',
    require => Package['puppet-agent'],
  }

  file { '/etc/puppetlabs/':
    ensure  => 'directory',
    owner   => 'puppet',
    group   => 'puppet',
    require => Package['puppet-agent'],
  }

  file { '/etc/puppetlabs/puppet/':
    ensure  => 'directory',
    owner   => 'puppet',
    group   => 'puppet',
    require => Package['puppet-agent'],
  }

  file { '/etc/puppetlabs/puppet/puppet.conf':
    ensure  => 'present',
    mode    => '0644',
    owner   => 'puppet',
    group   => 'puppet',
    source  => 'puppet:///modules/twitch_puppet/puppet5_config.conf',
    require => Package['puppet-agent'],
  }

  if $enable_cron {
    twitch_cron { 'puppet5-noop-agent-runs':
          ensure      => present,
          command     => '/opt/puppetlabs/bin/puppet agent -tv --noop',
          user        => 'root',
          environment => 'PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:/opt/puppetlabs/bin',
          minute      => fqdn_rand(59, $::fqdn),
          hour        => fqdn_rand(23, $::fqdn),
          monthday    => '*',
          month       => '*',
          weekday     => '*',
    }
  }

  # The following is to fix the messed-up ec2_userdata fact... has to be done via puppet3 because of fact placement
  # timing and such (it will place var/lib facter facts but not the one the blocks the built-ins in /opt/puppetlabs...)
  $facterdir = '/opt/puppetlabs/facter'
  file { $facterdir:
    ensure => 'directory',
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
    require => Package['puppet-agent'],
  }
  file { "$facterdir/facts.d":
    ensure => 'directory',
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
    require => Package['puppet-agent'],
  }

  file { "$facterdir/facts.d/ec2_userdata.txt":
    ensure  => 'file',
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => 'ec2_userdata=""',
    require => Package['puppet-agent'],
  }

}
