# Twitch puppet, sets up common puppet stuff
class twitch_puppet (
  $puppet4                = false,
  $master                 = false,
  $puppet_ca_server       = $twitch_puppet::params::puppet_ca_server,
  $puppet_agent_ensure    = $twitch_puppet::params::puppet_agent_ensure,
) inherits twitch_puppet::params {

  validate_bool($master, $puppet4)
  if $puppet4 {
    notify { 'Puppet4 set to TRUE':
      message =>  'Skipping all init.pp items',
    }
  } else {
    validate_string($puppet_ca_server, $puppet_agent_ensure)

    include twitch_puppet::config
    include twitch_puppet::external_facts
    include twitch_puppet::ca_certs

    class { 'twitch_puppet::agent':
      puppet_ca_server    => $puppet_ca_server,
      puppet_agent_ensure => $puppet_agent_ensure,
    }

    if $master {
      include twitch_puppet::master
    }
  }
}
