# Sets up filebeat prospectors to ship puppetmaster logs to centralized logging
class twitch_puppet::master::logging (
  $log_output_tag = $twitch_puppet::params::log_output_tag
) inherits twitch_puppet::params {
  validate_string($log_output_tag)

  video_cloudwatch::logfile { 'puppet_master_access':
    file_path        => '/var/log/nginx/puppetmaster_access.log',
    timestamp_format => '%d/%b/%Y:%H:%M:%S %z',
  }

  video_cloudwatch::logfile { 'puppet_master_error':
    file_path        => '/var/log/nginx/puppetmaster_error.log',
    timestamp_format => '%d/%b/%Y:%H:%M:%S %z',
  }

}
