# Sets up monit for unicorn
class twitch_puppet::master::monitoring (
    $unicorn_pidfile = $twitch_puppet::params::puppet_unicorn_pidfile,
    $puppet_rackdir  = $twitch_puppet::params::puppet_rackdir,
    $puppet_user     = $twitch_puppet::params::puppet_user,
    $puppet_group    = $twitch_puppet::params::puppet_group,
    $monit_mem_max   = $twitch_puppet::params::monit_mem_max,
) inherits twitch_puppet::params {
  include twitch_puppet::master

  validate_string($puppet_user, $puppet_group, $monit_mem_max)
  validate_absolute_path($puppet_rackdir, $unicorn_pidfile)

  twitch_monit::check { 'puppetmaster_unicorn':
    pidfile        => $unicorn_pidfile,
    cwd            => $puppet_rackdir,
    uid            => $puppet_user,
    gid            => $puppet_group,
    check_interval => 5,
    custom_checks  => [template("${module_name}/puppetmaster_unicorn_monit.conf.erb")],
    command        => 'unicorn -c unicorn.rb',
    require        => Package['puppetmaster'],
    subscribe      => Class['twitch_puppet::master::service'],
  }

}
