# Adds puppetdb stuff
class twitch_puppet::master::puppetdb (
  $puppetdb_server = $twitch_puppet::params::puppetdb_server,
) inherits twitch_puppet::params {

  validate_string($puppetdb_server)

  # This gem is required for the puppetdbquery module
  package { 'ruby-puppetdb':
    ensure   => '1.6.1',
    provider => 'gem',
    require  => [Package['rack'],Package['json']],
  }

  class { 'puppetdb::master::config':
    puppetdb_server             => $puppetdb_server,
    puppetdb_soft_write_failure => true,
    restart_puppet              => false,
  }
}
