# base parameters for twitch_puppet
class twitch_puppet4::params {
  $puppet_version               = 'latest'
  $puppet_server                = 'puppetserver-ca-0bc219d7fdc20695a.prod.us-west2.justin.tv'
  $puppet_ca_server             = 'puppet-ca.internal.justin.tv'
  $puppetdb_server              = 'puppetdb.internal.justin.tv'
  $puppet_user                  = 'puppet'
  $puppet_group                 = 'puppet'
  $puppet_confdir               = '/etc/puppetlabs/puppet'
  $puppet_conf                  = "${puppet_confdir}/puppet.conf"
  $puppet_logdir                = '/var/log/puppet'
  # this is used in configs and templates, first we prioritize
  # $::certname which is given from a master authority.
  # then, if that is undef, we take our $::fqdn. in any case of puppet apply
  $puppet_certname              = pick($::certname, $::fqdn, undef)

  $facter_root_dir              = '/etc/facter'
  $facter_facts_d               = "${facter_root_dir}/facts.d"

  $puppet_codedir               = '/etc/puppetlabs/code'
  $puppet_envdir                = "${puppet_codedir}/environments"
  $server_maindir               = '/etc/puppetlabs/puppetserver'
  $server_confdir               = "${server_maindir}/conf.d"
  $server_services              = "${server_maindir}/services.d"
  $puppet_homedir               = '/opt/puppetlabs/server/data/puppetserver'

  $git_server                   = 'git-aws.internal.justin.tv'
  $git_project                  = 'systems/puppet'

  $twitch_basedir               = hiera('twitch_basedir', '/opt/twitch')

  $puppetlabs_repo_enable       = true

  $puppet_github_webhook_port   = '8000'
  $puppet_github_webhook_dir    = '/opt/github-webhook-receiver'
  $puppet_github_webhook_script = 'github-webhook-receiver.py'
  $github_webhook_pidfile       = '/var/run/github-webhook-receiver/github-webhook-receiver.pid'
}
