# class twitch_puppet4::repo provides setup of PC1 repos for puppet4
class twitch_puppet4::repo {
  case $facts['os']['family'] {
    'Debian': {
      include apt

      $puppetlabs_gpg_key = {
        id     => '6F6B15509CF8E59E6E469F327F438280EF8D349F',
        server => 'pgp.mit.edu',
      }

      case $facts['os']['distro']['codename'] {
        /^(precise|trusty|xenial)$/: {
          apt::source { 'puppetlabs-internal':
            comment  => 'Internal puppetlabs PC1 Mirror for puppet4 support',
            location => 'http://packages.internal.justin.tv/artifactory/vr-puppet/',
            release  => $facts['os']['distro']['codename'],
            repos    => 'PC1',
            key      => $puppetlabs_gpg_key,
          }
        }
        default: {
          fail("os release ${facts['os']['distro']['codename']} not supported by this module!")
        }
      }
    }
    default: {
      fail("os family ${facts['os']['family']} not supported by this module!")
    }
  }
}
