# class twitch_puppet4::server configures puppetserver
class twitch_puppet4::server (
  $ca_enabled      = false,
  $profiler        = false,
  $puppet_codedir  = $twitch_puppet4::params::puppet_codedir,
  $puppet_envdir   = $twitch_puppet4::params::puppet_envdir,
  $server_maindir  = $twitch_puppet4::params::server_maindir,
  $server_confdir  = $twitch_puppet4::params::server_confdir,
  $server_services = $twitch_puppet4::params::server_services,
) inherits twitch_puppet4::params {
  require twitch_puppet4::repo
  include twitch_puppet4::agent
  include twitch_puppet4::server::webhook_receiver

  package { 'puppetserver':
    ensure  => latest,
    require => Package['puppet-agent'],
  }

  file { $puppet_codedir:
    ensure => directory,
    owner  => 'puppet',
    group  => 'puppet',
    mode   => '0755',
  }

  file { $puppet_envdir:
    ensure  => directory,
    owner   => 'puppet',
    group   => 'puppet',
    mode    => '0755',
    require => File[$puppet_codedir],
  }

  file { $server_maindir:
    ensure => directory,
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
  }

  file { $server_confdir:
    ensure => directory,
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
  }

  file { $server_services:
    ensure => directory,
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
  }

  service { 'puppetserver':
    ensure  => running,
    enable  => true,
    require => Package['puppetserver'],
  }

  file { "${twitch_puppet4::params::puppet_confdir}/hiera.yaml":
    ensure  => present,
    owner   => 'puppet',
    group   => 'puppet',
    mode    => '0644',
    content => template("${module_name}/hiera.yaml.erb"),
    notify  => Service['puppetserver'],
    require => Package['puppetserver'],
  }

  file { "${server_services}/ca.cfg":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template("${module_name}/ca.cfg.erb"),
    notify  => Service['puppetserver'],
    require => Package['puppetserver'],
  }

  file { "${server_confdir}/puppetserver.conf":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template("${module_name}/puppetserver.conf.erb"),
    notify  => Service['puppetserver'],
    require => Package['puppetserver'],
  }

}
