# Setups up the webhook receiver that keeps environments udpated
class twitch_puppet4::server::webhook_receiver(
  $github_webhook_port    = $twitch_puppet4::params::puppet_github_webhook_port,
  $github_webhook_dir     = $twitch_puppet4::params::puppet_github_webhook_dir,
  $github_webhook_script  = $twitch_puppet4::params::puppet_github_webhook_script,
  $github_webhook_pidfile = $twitch_puppet4::params::github_webhook_pidfile,
  $puppet_user            = $twitch_puppet4::params::puppet_user,
  $puppet_group           = $twitch_puppet4::params::puppet_group,
  $puppet_homedir         = $twitch_puppet4::params::puppet_homedir,
  $puppet_envdir          = $twitch_puppet4::params::puppet_envdir,
  $git_project            = $twitch_puppet4::params::git_project,
  $git_server             = $twitch_puppet4::params::git_server,
) inherits twitch_puppet4::params {

  file { $github_webhook_dir:
    ensure => directory,
    owner  => $puppet_user,
    group  => $puppet_group,
    mode   => '0755',
  }

  file { "${puppet_homedir}/.ssh":
    ensure => directory,
    owner  => $puppet_user,
    group  => $puppet_group,
    mode   => '0700',
  }

  $pid_dir = dirname($github_webhook_pidfile)

  file { $pid_dir:
    ensure => directory,
    owner  => $puppet_user,
    group  => $puppet_group,
    mode   => '0755',
  }

  file { "${github_webhook_dir}/${github_webhook_script}":
    ensure  => 'present',
    owner   => $puppet_user,
    group   => $puppet_group,
    mode    => '0755',
    content => template("${module_name}/${github_webhook_script}.erb"),
    require => File[$github_webhook_dir],
  }

  twitch_monit::check{ 'github-webhook-receiver':
    pidfile        => $github_webhook_pidfile,
    cwd            => $github_webhook_dir,
    uid            => $puppet_user,
    gid            => $puppet_group,
    command        => "python ${github_webhook_script}",
    check_interval => 5,
    require        => [
      File["${github_webhook_dir}/${github_webhook_script}"],
      File[$pid_dir]
    ],
  }

  file { "${puppet_homedir}/.ssh/config":
    ensure  => present,
    owner   => $puppet_user,
    group   => $puppetgroup,
    mode    => '0644',
    content => template("${module_name}/ssh_config.erb"),
    require => File["${puppet_homedir}/.ssh"],
  }

  # This key is for checking out the repo from git when an update is received
  $puppet_keyfile = "${puppet_homedir}/.ssh/id_rsa"

  twitch_sandstorm_agent::template { 'webhook-ssh-key-priv':
    destination => $puppet_keyfile,
    key         => 'syseng/puppet/production/webhook-systems-puppet-key',
    require     => File["${puppet_homedir}/.ssh"],
    mode        => '0600',
    owner       => $puppet_user,
    group       => $puppet_group,
  }

  twitch_sandstorm_agent::template { 'webhook-ssh-key-pub':
    destination => "${puppet_keyfile}.pub",
    key         => 'syseng/puppet/production/webhook-systems-puppet-pub',
    require     => File["${puppet_homedir}/.ssh"],
    mode        => '0644',
    owner       => $puppet_user,
    group       => $puppet_group,
  }

}

