# PuppetDB frontend, no DB
class twitch_puppetdb::frontend (
  $jvm_heap_size     = '24g',
  $database_host     = 'localhost',
  $node_ttl          = '7d',
  $node_purge_ttl    = '7d',
  $report_ttl        = '14d',
  $database_name     = 'puppetdb',
  $ldap_server       = hiera('ldap_server'),
  $database_password = undef,
){

  class { 'puppetdb::server':
    ssl_listen_address => '0.0.0.0',
    database_host      => $database_host,
    node_ttl           => $node_ttl,
    node_purge_ttl     => $node_purge_ttl,
    report_ttl         => $report_ttl,
    database_name      => $database_name,
    java_args          => {'-Xmx' => $jvm_heap_size},
    listen_address     => '0.0.0.0',
    database_password  => undef,
    database_validate  => false,
  }

  twitch_nginx::vhost { 'puppetdb':
    content => template('twitch_puppetdb/nginx_elb.conf.erb'),
  }

  twitch_sandstorm_agent::template { 'puppetdb-private':
    destination => '/etc/puppetdb/ssl/private.pem',
    key         => 'syseng/puppet/production/puppet-db-frontend.private',
    require     => Class['puppetdb::server'],
    mode        => '0600',
    owner       => 'puppetdb',
    group       => 'puppetdb',
  }

  twitch_sandstorm_agent::template { 'pupeptdb-public':
    destination => '/etc/puppetdb/ssl/public.pem',
    key         => 'syseng/puppet/production/puppet-db-frontend.public',
    require     => Class['puppetdb::server'],
    mode        => '0644',
    owner       => 'puppetdb',
    group       => 'puppetdb',
  }

  twitch_sandstorm_agent::template { 'pupeptdb-ca':
    destination => '/etc/puppetdb/ssl/ca.pem',
    key         => 'syseng/puppet/production/puppet-db-frontend.ca',
    require     => Class['puppetdb::server'],
    mode        => '0644',
    owner       => 'puppetdb',
    group       => 'puppetdb',
  }

  twitch_sandstorm_agent::template { 'puppet_db_password':
    destination     => '/etc/puppetdb/conf.d/database.ini',
    contents        => template("${module_name}/database.ini.erb"),
    restart_command => '/etc/init.d/puppetdb restart',
    require         => Class['puppetdb::server'],
  }
  if $::twitch_environment == 'production' {
    twitch_servicecheck::passive { 'PuppetDB TCP':
      command => 'check_tcp -H localhost -p 8081',
    }
  }
}
