# Install stock puppetdb using puppetdb module
# Defaults to embedded postgres
class twitch_puppetdb (
  $jvm_heap_size  = '8g',
  $node_ttl       = '7d',
  $node_purge_ttl = '7d',
  $report_ttl     = '14d',
  $database_name  = 'puppetdb',
  $database_host  = 'localhost',
) {

  ## configure postgresql first
  class { 'postgresql::globals':
    manage_package_repo => true,
    version             => '9.3',
  } ->
  class { 'postgresql::server::contrib':
  } ->
  postgresql::server::extension { 'pg_trgm':
    database => $database_name,
  } ->
  class { 'puppetdb':
    ssl_listen_address      => '0.0.0.0',
    node_ttl                => $node_ttl,
    node_purge_ttl          => $node_purge_ttl,
    report_ttl              => $report_ttl,
    database_name           => $database_name,
    java_args               => {'-Xmx' => $jvm_heap_size},
    database_listen_address => '*',
  }

  ## nginx helper
  # TODO: If we ever bring back puppetdb, 
  # 1. hopefully it's not bare metal by puppet
  # 2. Add a new cert that isn't wildcard internal
  twitch_nginx::vhost { 'puppetdb':
    content => template('twitch_puppetdb/nginx.conf.erb'),
  }

  ## nrpe check for postgres port
  nrpe::command { 'check_postgres_port':
    ensure  => 'present',
    command => 'check_tcp -H "localhost" -p 5432'
  }

}
