# Twitch Puppet Module

This module installs Puppet, and configures the machine to become a remote
puppet agent, or a puppet master.


### Configuration

There are a few usages of this module:

To install/configure puppet and point it at our puppet masters:

    include twitch_puppet

To install/configure puppet to be a puppet master, first set `puppet_master:
true` in hiera for the node or cluster, then:

    include twitch_puppet


##### Puppetmaster setup

When bringing up a puppetmaster with this module, assuming you're using the minimal
config and want it to work on a PoPmaster (`twitch_puppet::master: true`), using
our existing puppet CA, it will:

1. Generate a new CSR and submit it to our CA.
    * This certificate _cannot_ be automatically
      signed because it contains DNS alt names, so you must manually sign it. To
      do that, SSH to `puppet-ca.internal.justin.tv` and `puppet cert --allow-dns-alt-names sign hostname.tv`.

      There's a small helper script already running on your new puppetmaster
      which is just waiting for the cert to be signed. Once that's done, the helper
      will automatically restart the services that failed to start without a cert.

2. Generate an SSH key for the `puppet` user.
    * This SSH needs to be submitted to GitHub for automatic deploys to work, so
      puppet will run a script at `/opt/twitch/puppetmaster_github_setup.sh` which
      requires a set of github credentials in the file `/var/lib/puppet/github_pass`.

      That file should look like:

          GITHUB_USERNAME=yourgithubusername
          GITHUB_PASSWORD="yourgithubpassword"

      The script will first upload the new public key, then create a webhook pointing
      back at your new puppetmaster.

3. Clone the current puppet repo into `/etc/puppet/environments/master`, assuming
   the SSH key was uploaded in the previous step. If your `github_pass` file wasn't
   available during your first run, put it in place and run puppet again so that
   this module can clone the repository.

##### Puppet CA

To configure a single puppet master server as a Certificate Authority (CA), you
would add the following to hiera:

    puppet_master: true
    puppet_ca: true


### Puppet Certificate Instructions

The server portion of this module attempts to setup a puppet master without
trying to muck with the certificates, in case you wanted to manually port over
existing SSL certificates. This means that if you're setting up a puppet CA
from scratch with no intention of migrating, you'll need to do some manual
things to setup the certificates correctly.

A few things to consider:

* PuppetCA runs on 1 server only.
* PuppetCA is only queried directly for first run certificate request/signing.


Steps to create first certs:

* Generate a master cert with puppetca in DNS alt names

    $ puppet cert list
    Notice: Signed certificate request for ca

3.




### UPDATED

  puppetmaster apt package from puppetlabs setups new certificates
