# sets up puppet agent  This is all broken out into the agent/ subclasses now
class twitch_puppet::agent (
  $puppet_ca_server     = $twitch_puppet::params::puppet_ca_server,
  $puppet_server        = $twitch_puppet::params::puppet_server,
  $puppet_agent_package = $twitch_puppet::params::puppet_agent_package,
  $puppet_agent_ensure  = $twitch_puppet::params::puppet_agent_ensure,
) inherits twitch_puppet::params {

  validate_string($puppet_ca_server, $puppet_server, $puppet_agent_package, $puppet_agent_ensure)

  include twitch_puppet

  class { 'twitch_puppet::agent::install':
    puppet_agent_package => $puppet_agent_package,
    puppet_agent_ensure  => $puppet_agent_ensure,
  }

  class { 'twitch_puppet::agent::config':
    puppet_ca_server => $puppet_ca_server,
    puppet_server    => $puppet_server,
  }

  contain 'twitch_puppet::agent::install'
  contain 'twitch_puppet::agent::config'
  contain 'twitch_puppet::agent::service'
  contain 'twitch_puppet::agent::metrics'

  Class['twitch_puppet::agent::install']
  -> Class['twitch_puppet::agent::config']
  -> Class['twitch_puppet::agent::service']
  -> Class['twitch_puppet::agent::metrics']
}
