# Define: twitch_puppet::ca_certs::cert
#
# Poor man's for-each loop
define twitch_puppet::ca_certs::cert(
  $user  = $twitch_puppet::params::puppet_user,
  $group = $twitch_puppet::params::puppet_group,
) {

  require openssl
  validate_string($user, $group)
  $cert_path     = '/etc/ssl/certs'
  $file_contents = file("${module_name}/ca-certs/${title}.pem")

  # we can't install sandstorm on all hosts.. yet so toggle off sandstorm resources.
  twitch_ssl_certificate::certificate { "${module_name}_${title}":
    require_sandstorm    => false,
    cert_filesystem_path => "${cert_path}/${title}.pem",
    cert_contents        => $file_contents,
    cert_owner           => $user,
    cert_group           => $group,
    cert_mode            => '0644',
    cert_self_signed     => true,
  }

}
