# twitch_puppetserver::config - manage puppet user/group/dirs/config
class twitch_puppetserver::config (
  $puppet_group    = $twitch_puppetserver::params::puppet_group,
  $puppet_user     = $twitch_puppetserver::params::puppet_user,
  $puppet_confdir  = $twitch_puppetserver::params::puppet_confdir,
  $puppet_conf     = $twitch_puppetserver::params::puppet_conf,
) inherits twitch_puppetserver::params {

  # Validate Stuff
  validate_string($puppet_user, $puppet_group)
  validate_absolute_path($puppet_confdir, $puppet_conf)

  group { $puppet_group:
    ensure => 'present',
    system => true,
  }

  user { $puppet_user:
    system => true,
    gid    => $puppet_group,
  }

  file { [$facter_root_dir,$facter_facts_d]:
    ensure => 'directory',
    owner  => 'root',
    group  => 'root',
    mode   => '0755',
  }

  file { $puppet_confdir:
    ensure => 'directory',
    owner  => $puppet_user,
    group  => $puppet_group,
    mode   => '0755',
  }

  file { $puppet_conf:
    ensure  => 'file',
    owner   => $puppet_user,
    group   => $puppet_group,
    mode    => '0644',
    require => File[$puppet_confdir],
  }

}
