# Twitch puppet, sets up common puppet stuff
class twitch_puppetserver (
  $puppet_ca_server       = $twitch_puppetserver::params::puppet_ca_server,
  $puppet_agent_ensure    = $twitch_puppetserver::params::puppet_agent_ensure,
) inherits twitch_puppetserver::params {
  
  validate_string($puppet_ca_server, $puppet_agent_ensure)

  include twitch_puppetserver::config
  include twitch_puppetserver::external_facts
  include twitch_puppetserver::ca_certs

  class { 'twitch_puppet::agent5':
    puppet_ca_server    => $puppet_ca_server,
    puppet_agent_ensure => $puppet_agent_ensure,
  }
}
