# sets up a puppetmaster
class twitch_puppet::master (
  $puppet_master_package = $twitch_puppet::params::puppet_master_package,
  $puppet_master_version = $twitch_puppet::params::puppet_master_version,
  $bootstrap             = $twitch_puppet::params::bootstrap,
  $ca                    = $twitch_puppet::params::ca,
  $puppetdb_server       = $twitch_puppet::params::puppetdb_server,
  $puppet_ca_server      = $twitch_puppet::params::puppet_ca_server,
  $puppet_server         = $twitch_puppet::params::puppet_server,
) inherits twitch_puppet::params {
  include twitch_puppet

  validate_string($puppet_server, $puppet_ca_server, $puppetdb_server)
  validate_string($puppet_master_package, $puppet_master_version)
  validate_bool($ca, $bootstrap)
  class { 'twitch_puppet::master::install':
      puppet_master_package => $puppet_master_package,
      puppet_master_version => $puppet_master_version,
      puppetdb_server       => $puppetdb_server,
      puppet_ca_server      => $puppet_ca_server,
      puppet_server         => $puppet_server,
  }

  class { 'twitch_puppet::master::config':
      bootstrap => $bootstrap,
      ca        => $ca,
  }

  contain 'twitch_puppet::master::install'
  contain 'twitch_puppet::master::config'
  contain 'twitch_puppet::master::service'
  contain 'twitch_puppet::master::monitoring'
  contain 'twitch_puppet::master::logging'

  Class['twitch_puppet::master::config']
  -> Class['twitch_puppet::master::install']
  ~> Class['twitch_puppet::master::service']
  -> Class['twitch_puppet::master::monitoring']
  -> Class['twitch_puppet::master::logging']
}
