# Splits out the puppetmaster install stuff from master.pp
class twitch_puppet::master::install (
  $puppet_master_package = $twitch_puppet::params::puppet_master_package,
  $puppet_master_version = $twitch_puppet::params::puppet_master_version,
  $puppet_master_ensure  = $twitch_puppet::params::puppet_master_ensure,
  $puppetdb_server       = $twitch_puppet::params::puppetdb_server,
  $puppet_ca_server      = $twitch_puppet::params::puppet_ca_server,
  $puppet_server         = $twitch_puppet::params::puppet_server,
  $puppet_confdif        = $twitch_puppet::params::puppet_confdir,
  $ca                    = $twitch_puppet::params::ca,
  $puppet_unicorn_socket = $twitch_puppet::params::puppet_unicorn_socket,
  $puppet_ssldir         = $twitch_puppet::params::puppet_ssldir,
) inherits twitch_puppet::params {
  include twitch_puppet::master

  validate_string($puppetdb_server, $puppet_master_package, $puppet_ca_server)
  validate_string($puppet_master_version, $puppet_master_ensure)
  validate_absolute_path($puppet_ssldir, $puppet_unicorn_socket)
  validate_bool($ca)
  include twitch_unicorn::package

  twitch_nginx::vhost { 'puppetmaster':
    content => template('twitch_puppet/nginx.conf.erb'),
  }

  twitch_nginx::vhost { 'status':
    source => 'puppet:///modules/twitch_puppet/master/status.conf',
  }

  package { ['puppetmaster-common', 'puppetmaster']:
    ensure => $puppet_master_ensure,
  }

  package { 'rack':
    ensure   => '1.6.0',
    provider => 'gem',
  }

  package { 'unicorn-worker-killer':
    ensure   => '0.4.4',
    provider => 'gem',
  }

  package { 'json':
    ensure   => '1.8.3',
    provider => 'gem',
  }

  if $puppetdb_server != '' {
    include twitch_puppet::master::puppetdb
  }
}
