# base parameters for twitch_puppet
class twitch_puppet::params {

  case $facts['lsbdistcodename'] {
    'bionic': {
      $puppet_agent_package = 'omnibus-puppet'
      $puppet_agent_ensure  = 'latest'
      $puppet_pidfile       = '/var/run/puppet/master.pid'
    }
    default: {
      $puppet_agent_package = 'puppet'
      $puppet_agent_ensure  = '3.8.5-2ubuntu0.1'
      $puppet_pidfile       = '/var/run/puppet/master.pid'
    }
  }

  $puppet_server_set = hiera('puppet_server_set','production')
  case $puppet_server_set {
    'production': {
      $puppet_server          = 'video-puppet.prod.puppet.live-video.a2z.com'
      $puppet_ca_server       = 'video-puppet-ca.prod.puppet.live-video.a2z.com'
      $puppetdb_server        = ''
    }
    'staging': {
      $puppet_server          = 'video-puppet.stage.puppet.live-video.a2z.com'
      $puppet_ca_server       = 'video-puppet-ca.stage.puppet.live-video.a2z.com'
      $puppetdb_server        = ''
    }
    default: {
      $puppet_server          = 'video-puppet.prod.puppet.live-video.a2z.com'
      $puppet_ca_server       = 'video-puppet-ca.prod.puppet.live-video.a2z.com'
      $puppetdb_server        = ''
    }
  }

  $puppet_user            = 'puppet'
  $puppet_group           = 'puppet'

  # this is used in configs and templates, first we prioritize
  # $::certname which is given from a master authority.
  # then, if that is undef, we take our $::fqdn. in any case of puppet apply
  $puppet_certname        = pick($::certname, $::fqdn, undef)

  $puppet_confdir         = '/etc/puppet'
  $puppet_conf            = "${puppet_confdir}/puppet.conf"
  $puppet_environment_dir = "${puppet_confdir}/environments"
  $puppet_production_link = "${puppet_environment_dir}/master"

  $puppet_logdir          = '/var/log/puppet'
  $log_output_tag         = 'syslog_elasticsearch'

  # master stuff
  $puppet_master_package  = $puppet_agent_package
  $puppet_master_ensure   = $puppet_agent_ensure

  $puppet_vardir          = '/var/lib/puppet'
  $puppet_ssldir          = "${puppet_vardir}/ssl"
  $puppet_rackdir         = "${puppet_confdir}/rack"

  $facter_root_dir        = '/etc/facter'
  $facter_facts_d         = "${facter_root_dir}/facts.d"

  # unicorn configuration for server component
  $puppet_unicorn_socket  = "${puppet_rackdir}/puppetmaster_unicorn.sock"
  $puppet_unicorn_pidfile = '/var/run/puppet/puppetmaster_unicorn.pid'

  # These setup the agent for most hosts
  $git_server             = 'git-aws.internal.justin.tv'
  $git_project            = 'video-puppet/puppet-monolith'

  # This should be 30
  $puppet_run_interval    = 30
  $puppet_run_style       = 'manual'
  $puppet_run_command     = '/usr/bin/puppet agent --no-daemonize --onetime --no-usecacheonfailure --no-splay --show_diff --verbose'
  $monit_mem_max          = '70%'

  $enable_diamond         = true
  $diamond_collector_opts = { path_prefix => 'video-servers', }

  $bootstrap              = false
  $ca                     = false
}
