"""
ttv netdb stuff
"""

from logging import getLogger, StreamHandler
import sys

import ttv
from ttv import borg, objcached
from ttv import config
import ttv.db
from ttv.db import DbRo, DbRw, Table

# global logger for this library
log = getLogger('ttv.db.netdb')  # pylint: disable=C0103


#############################################################################

config.var('NETDB_DB', 'network')
config.var('NETDB_USER', 'usher_readwrite')
config.var('NETDB_PASSWORD', 'ratspourmarblehomes')

config.var('NETDB_HOSTS', 'usherdb-6f4488.sfo01.justin.tv,usherdb-7ecd3c.sfo01.justin.tv,usherdb-6db4a0.sfo01.justin.tv')

NETDB_HOST_LIST = NETDB_HOSTS.split(',')  # pylint: disable=E0602
config.var('NETDB_PORT', 6544)

class NetDbRw(DbRw):
    """A read-write connection to netdb. You must supply the host and port..."""
    def __init__(self, host, port):
        super(NetDbRw, self).__init__(database=NETDB_DB,  # pylint: disable=E0602
                                      host=host,
                                      user=NETDB_USER,  # pylint: disable=E0602
                                      port=port,
                                      password=NETDB_PASSWORD)  # pylint: disable=E0602


class Hoses(Table):
    def __init__(self, host, port):
        Table.__init__(self, NetDbRw(host, port), 'hoses', ('id', 'cluster_id', 'name', 'type', 'max_mbps', 
                                                            'current_mbps', 'current_updated_on', 'previous_mbps', 
                                                            'previous_updated_on'))
