"""
deploy-related
"""

from logging import getLogger
import time
import os
import os.path

from ttv import config


# global logger for this library
log = getLogger('ttv.deploy')  # pylint: disable=C0103


config.var('GITROOT', '/etc/puppet/environments')


def deploy(projname, pathlist, branch='master'):
    os.execlp('/bin/bash', 'bash', '-xc', """\
set -xe
ts=$(date +%F_%T)""" + """
releases=/home/jtv/%(projname)s/releases
mkdir -p $releases/$ts
rsync -a --delete %(syncsrc)s $releases/$ts/.
ln -sfn $releases/$ts $releases/current
cd $releases/current
export WORKON_HOME=/home/jtv/virtualenvs
. /usr/local/bin/virtualenvwrapper.sh
mkvirtualenv %(projname)s
workon %(projname)s
pip install -r %(projname)s_requirements.txt
""" % {'projname': projname, 
       'syncsrc': ' '.join(['%s/%s/files/misc/%s' % 
                            (GITROOT, branch, path) for path in pathlist])})  # pylint: disable=E0602
    log.critical('but this is impossible!')
    exit(1)
