"""
nagios-related
"""

import sys
import os
from collections import defaultdict
import atexit
import logging


# global logger for this library
log = logging.getLogger('ttv.nagios')  # pylint: disable=C0103


# nagios exit codes
NOK = 0
NWARNING = 1
NCRITICAL = 2
NUNKNOWN = 3


# nagios_notes[exit_code] is a list of all relevant messages
nagios_notes = defaultdict(list)  # pylint: disable=C0103

# ensure that there is a max(nagios_notes.keys())
nagios_notes[NOK] = []


def print_notes():
    """print notes"""
    for key in sorted(nagios_notes.keys(), reverse=True):
        for note in nagios_notes[key]:
            print note


def nagios_exit():
    """exit with the right code"""
    exit_code = max(nagios_notes.keys())
    os.close(2) # close stderr because of https://www.google.com/search?q=KeyError+threading+python
    sys.exit(exit_code)
    

@atexit.register
def print_notes_and_exit():
    """This gets called on exit"""
    print_notes()
    nagios_exit()


def nagios_note(code, message):
    """Call this when you want to communicate something. It
    accumulates and gets dumped at exit"""

    if code not in (NOK, NWARNING, NCRITICAL, NUNKNOWN):
        nagios_notes[NUNKNOWN].append('nagios code %s is unkown!' % code)
        code = NUNKNOWN

    nagios_notes[code].append(message)
