#!/usr/bin/env python

"""
Test ttv.config
"""

# pylint: disable=R0904,C0111,E0602
# R0904: too-many-public-methods
# C0111: missing-docstring
# E0602: undefined-variable


import unittest
import sys
from os.path import dirname, abspath
import os

sys.path.insert(0, dirname(dirname(dirname(abspath(__file__)))))
import ttv
import ttv.config

ttv.config.var('FOO', 'foo')

os.environ['BAR'] = 'baz'
ttv.config.var('BAR', 'bar')

ttv.config.var('BAZOOKA', 'yes', namespace='ttv.config')

ttv.config.var('BAZ', 44, vartype=int)
ttv.config.var('FLARP', 42, vartype='int')
ttv.config.var('PI', 3.14)
ttv.config.var('PISTR', '3.14')

class TestConfigVar(unittest.TestCase):


    def test_basic(self):
        self.assertEqual(FOO, 'foo')

    def test_env_override(self):
        self.assertEqual(BAR, 'baz')

    def test_namespace(self):
        self.assertEqual(ttv.config.BAZOOKA, 'yes')  # pylint: disable=E1101
        
    def test_vartype(self):
        self.assertEqual(BAZ, 44)
        self.assertEqual(FLARP, 42)
        self.assertEqual(PI, 3.14)
        self.assertEqual(PISTR, '3.14')


if __name__ == '__main__':
    unittest.main()

