#!/usr/bin/env python

"""
Test ttv.kimchi
"""

# pylint: disable=R0904,C0111
# R0904: too-many-public-methods
# C0111: missing-docstring


import unittest
import sys

from os.path import dirname, abspath

sys.path.insert(0, dirname(dirname(dirname(abspath(__file__)))))
import ttv
import ttv.kimchi


class TestGetStuff(unittest.TestCase):

    def test_get_objects(self):
        objs = ttv.kimchi.get_objects(name='sfo01', type='datacenter').json
        self.assertTrue(len(objs) == 1)
        objs = ttv.kimchi.get_objects(type='router').json
        self.assertTrue(12 < len(objs) < 50)
        objs = ttv.kimchi.get_objects(ip__startswith='10.1.12').json
        self.assertTrue(10 < len(objs) < 100)  # this may break eventually

    def test_get_statuses(self):
        objs = ttv.kimchi.get_statuses(name='Available').json
        self.assertTrue(len(objs) == 1)


class TestPostStuff(unittest.TestCase):

    def test_post_object(self):
        pass


class TestBRL(unittest.TestCase):

    def test_brl(self):
        brl = ttv.kimchi.border_router_list()
        self.assertTrue(len(brl) > 10)
        self.assertTrue('br01.sfo01.justin.tv' in [x['fqdn'] for x in brl])
        self.assertTrue('br02.arn01.justin.tv' in [x['fqdn'] for x in brl])
        self.assertTrue(all([x in brl[0] for x in ('domain_name', 'fqdn', 'cluster', 'name')]))

if __name__ == '__main__':
    unittest.main()

