#!/usr/bin/env python

"""
Test ttv.s3
"""

# pylint: disable=R0904,C0111,E0602
# R0904: too-many-public-methods
# C0111: missing-docstring
# E0602: undefined-variable



import unittest
import sys
import os
from os.path import dirname, abspath

import requests

sys.path.insert(0, dirname(dirname(dirname(abspath(__file__)))))
import ttv
import ttv.s3
from ttv import config


# (AK and SK from workers repo)
config.var('TEST_AK', '1ANPVWD7JBQH07CENYR2')
config.var('TEST_SK', 'pUJcXThjf3m8u0iW12uwQTf3NHgOxWkXGjt/zSOm')
config.var('TEST_BUCKET', 'ttvtesting')
config.var('TEST_FILE', 'hippopotamus58mercedes.txt')
config.var('TEST_DATA', 'foo')


class TestS3(unittest.TestCase):

    def setUp(self):
        # pylint: disable=C0103
        self.tmpfile = '/tmp/%s.txt' % os.getpid()
        open(self.tmpfile, 'w+').write(TEST_DATA)

    def tearDown(self):
        # pylint: disable=C0103
        ttv.unlink_ignore(self.tmpfile)

    def test_delete_put_get_delete(self):
        # pre-emptive delete
        ttv.s3.delete(TEST_BUCKET, TEST_FILE, ak=TEST_AK, sk=TEST_SK)
        
        # file should be absent
        response = ttv.s3.get(TEST_BUCKET, TEST_FILE, ak=TEST_AK, sk=TEST_SK)
        self.assertFalse(200 <= response.status <= 299)
        
        # put the file
        response = ttv.s3.put(TEST_BUCKET, TEST_FILE, ak=TEST_AK, sk=TEST_SK, data=open(self.tmpfile).read(), 
                              content_type='text/plain')
        self.assertTrue(200 <= response.status <= 299)

        # get the file and check its contents
        response = ttv.s3.get(TEST_BUCKET, TEST_FILE, ak=TEST_AK, sk=TEST_SK)
        self.assertTrue(200 <= response.status <= 299)
        self.assertEqual(response.read(), TEST_DATA)

        # get the file another way and check its contents
        r = ttv.requests_wrapper(requests.get, 'http://%s/%s/%s' % 
                                 (ttv.s3.S3HOST, TEST_BUCKET, TEST_FILE))  # pylint: disable=E1101
        self.assertTrue(r is not None)
        self.assertEqual(r.text, TEST_DATA)  # pylint: disable=E1103
        
        # delete
        response = ttv.s3.delete(TEST_BUCKET, TEST_FILE, ak=TEST_AK, sk=TEST_SK)
        self.assertTrue(200 <= response.status <= 299)
        
        # file should be absent
        response = ttv.s3.get(TEST_BUCKET, TEST_FILE, ak=TEST_AK, sk=TEST_SK)
        self.assertFalse(200 <= response.status <= 299)
        

if __name__ == '__main__':
    unittest.main()

