#!/usr/bin/env python

"""
Test ttv.db.sitedb functionality.
"""

# pylint: disable=R0904,C0111,R0801
# R0904: too-many-public-methods
# C0111: missing-docstring
# R0801: duplicate-code


import unittest
import sys
from os.path import dirname, abspath

sys.path.insert(0, dirname(dirname(dirname(abspath(__file__)))))
import ttv
import ttv.db.sitedb

class TestSiteDbRo(unittest.TestCase):

    def setUp(self):  # pylint: disable=C0103
        self.sdb = ttv.db.sitedb.SiteDbRo()

    def test_trivial(self):
        self.assertEqual(self.sdb.execute('SELECT 1').fetchone(), 
                         (1,))

    def test_sqlargs_seq(self):
        self.assertEqual(self.sdb.execute('SELECT %s', (2,)).fetchone(), 
                         (2,))
        self.assertEqual(self.sdb.execute('SELECT %s, %s', (3, 4)).fetchone(), 
                         (3, 4))

    def test_sqlargs_dict(self):
        result = self.sdb.execute('SELECT %(foo)s', {'foo': 2}).fetchone()
        self.assertEqual(result, (2,))

    def test_adaptation(self):
        result = self.sdb.execute('SELECT %s IN %s', (2, tuple([2, 3, 4]))).fetchone()
        self.assertEqual(result, (True,))
        result = self.sdb.execute('SELECT %s IN %s', [2, tuple([2, 3, 4])]).fetchone()
        self.assertEqual(result, (True,))
        result = self.sdb.execute('SELECT %s IN %s', (1, (2, 3, 4))).fetchone()
        self.assertEqual(result, (False,))

    def test_vodhosts(self):
        vh = ttv.db.sitedb.VodHosts()
        self.assertTrue(len(vh.all_hosts()) > 30)
        self.assertTrue(vh.lookup_by_host('store48.media48')['id'] == 13)
        self.assertTrue(vh.lookup_by_id(13)['host'] == 'store48.media48')


class TestSiteDbRw(unittest.TestCase):

    # TODO: put something here. Should use devdb.
    pass


if __name__ == '__main__':
    unittest.main()
