#!/usr/bin/env python

"""
Test ttv.usher
"""

# pylint: disable=R0904,C0111
# R0904: too-many-public-methods
# C0111: missing-docstring


import unittest
import sys

from os.path import dirname, abspath

sys.path.insert(0, dirname(dirname(dirname(abspath(__file__)))))
import ttv
import ttv.usher


class TestClusterIdMap(unittest.TestCase):

    def test_cim(self):
        cim = ttv.usher.cluster_id_map()
        self.assertTrue('ams01' in cim)
        self.assertTrue(cim['sfo01'] == 48)

if __name__ == '__main__':
    unittest.main()

