"""
Usher-related functions
"""

import requests
from logging import getLogger

from ttv import requests_wrapper, config, cached


# (change these as needed for testing)
config.var('USHER_SCHEME', 'http')
config.var('USHER_HOST', 'usher.justin.tv')
config.var('USHER_PORT', 80)

log = getLogger('ttv.usher')  # pylint: disable=C0103


def cluster_id_map():
    """Get a mapping of cluster name to id from usher via API. Cache this as needed/desired."""

    # pylint: disable=E1103

    url = '%s://%s:%s/cluster/list.json' % (USHER_SCHEME, USHER_HOST, USHER_PORT)  # pylint: disable=E0602
    try:
        clusters = requests_wrapper(requests.get, url).json
        return dict([(cluster['name'], cluster['id']) for cluster in clusters])
    except (KeyError, IndexError, AttributeError):
        log.critical('could not get cluster_id mapping from usher (%s)!', url)
        return None


