define twitch_python::easy_install(
  $pymodname = '',
  $version = '',
){
  require twitch_proxy_config
  include twitch_python

  $fullname = $version ? {
    /^[0-9]*/ => "${name}==${version}",
    default   => $name
  }

  $pyversion = $twitch_python::params::python_version

  $_twitch_no_proxy   = $twitch_proxy_config::no_proxy
  $_twitch_no_proxy_a = [join($_twitch_no_proxy, ',')]
  $_no_proxy_merged   = flatten([prefix($_twitch_no_proxy_a, 'NO_PROXY='), prefix($_twitch_no_proxy_a, 'no_proxy=')])

  exec { "easy_install_${name}":
    environment => $_no_proxy_merged,
    command     => "easy_install -U ${fullname}",
    creates     => "/usr/local/lib/python${pyversion}/dist-packages/${name}-${version}-py${pyversion}.egg",
    logoutput   => true,
    path        => '/usr/local/bin:/usr/bin',
    require     => Class['twitch_python'],
  }
}
