class twitch_python (
  $install_pip        = $twitch_python::params::install_pip,
  $pypi_url           = $twitch_python::params::pypi_url,
  $python_basedir     = $twitch_python::params::python_basedir,
  $manage_gunicorn    = $twitch_python::params::manage_gunicorn,
  $install_gunicorn   = $twitch_python::params::install_gunicorn,
  $provider           = $twitch_python::params::provider,
) inherits twitch_python::params {
  validate_bool($install_pip)
  validate_re($install_gunicorn, ['^(absent|present|latest)$'])
  validate_string($pypi_url)
  validate_absolute_path($python_basedir)

  include twitch_python::pip::requests

  class{ '::python':
    pip             => 'absent', # Installing pip via twitch_python::pip::install
    dev             => 'present',
    virtualenv      => 'absent',
    gunicorn        => $install_gunicorn,
    manage_gunicorn => $manage_gunicorn,
    provider        => $provider,
  }

  -> class { '::twitch_python::pip::virtualenv':
  }

  package{ 'python-setuptools':
    ensure  => latest,
    require => Class['::python'],
  }

  $python_imaging = $::lsbdistcodename ? {
    precise => 'python-imaging',
    default => 'python-pil',
  }

  $python_packages_extra = [
    'python-egenix-mx-base-dev',
    'python-egenix-mxdatetime',
    $python_imaging,
    'python-memcache',
    'python-simplejson',
    'python-yaml',
  ]

  package { $python_packages_extra:
    ensure  => present,
    require => Class['::python'],
  }

  file {"${python_basedir}/distutils/distutils.cfg":
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template('twitch_python/pydistutils.cfg.erb'),
    require => [Class['::python'],Package['python-setuptools']],
  }

  if member(['lucid', 'precise'], $::lsbdistcodename) {
    package{ 'python-central':
      ensure  => installed,
      require => Class['::python'],
    }
  }

  if ($install_pip) {
    include twitch_python::pip::install
  }

  # include twitch_python::pip::virtualenv
  include twitch_python::virtualenv_directory
  include twitch_python::pip::virtualenvwrapper

}
