class twitch_python::params {
  $python_version = $::lsbdistcodename ? {
    default => '2.7',
  }

  $virtualenv_version = $::lsbdistcodename ? {
    'precise' => '1.7.1.2',
    'trusty'  => '13.1.2',
    'bionic'  => '15.1.0',
    default   => '15.0.1',
  }

  $pip_version        = $::lsbdistcodename ? {
    'trusty' => '7.1.2',
    'xenial' => '8.1.1',
    'bionic' => '9.0.1',
    default  => '1.5.4'
  }

  $python_basedir = "/usr/lib/python${python_version}"
  $install_gunicorn   = 'absent'
  $install_pip        = true
  $manage_gunicorn    = false
  $provider           = undef
  $pypi_url           = hiera('pypi_mirror')

}
