define twitch_python::pip (
  $pip_ensure      = 'installed',
  $pip_provider    = 'twitch_pip',
  $pkg_remove_name = undef,
  $pip_source      = undef,
  $pip_name        = undef,
) {

  include twitch_python::pip::install

  validate_string($pip_ensure)
  validate_string($pip_provider)

  if ($pip_name) {
    $real_name = $pip_name
  } else {
    $real_name = $name
  }

  if ($pkg_remove_name) {
    $real_pkg_remove_name = $pkg_remove_name
  } else {
    $real_pkg_remove_name  = "python-${name}"
  }

  case $pip_ensure {
    'present','installed': {
      $pensure = 'present'
    }
    /^[0-9]*/: {
      $pensure = $pip_ensure
    }
    'absent','purged': {
      $pensure = 'absent'
    }
    default: {
      $pensure = 'present'
    }
  }

  package{ $real_pkg_remove_name:
    ensure => absent,
  }

  package{ $real_name:
    ensure   => $pensure,
    provider => $pip_provider,
    require  => [Package[$real_pkg_remove_name],Class['twitch_python::pip::install'],],
  }
}
