class twitch_python::pip::flvtools (
  $pip_name   = 'FLVTOOLS',
  $ensure     = '1.6',
  $virtualenv = 'system',
  $owner      = 'root',
  $url        = 'git+ssh://git@git.internal.justin.tv/video/flvtools.git@32f71150084e9fb6b5d53d2cc7bf023fa81dae59',
){

  require twitch_python::pip::install

  #  ::python::pip { $pip_name:
  #  ensure     => $ensure,
  #  virtualenv => $virtualenv,
  #  owner      => $owner,
  #  url        => $url,
  #  require    => Class['twitch_python::pip::install'],
  #}

  # Super hacky to unblock - MB
  $package_name = "flvtools-${ensure}.tar.gz"

  file{ "/tmp/${package_name}":
    ensure => present,
    owner  => 'root',
    group  => 'root',
    source => 'puppet:///modules/twitch_python/flvtools-1.6.tar.gz',
    notify => Exec['pip install flvtools'],
  }

  exec{ 'pip install flvtools':
    user        => 'root',
    cwd         => '/tmp',
    command     => "/usr/local/bin/pip install ${package_name}",
    refreshonly => true,
    require     => File["/tmp/${package_name}"],
  }
}
