class twitch_python::pip::ipaddr (
  $pip_name   = 'ipaddr',
  $ensure     = '2.1.5',
  $virtualenv = 'system',
  $owner      = 'root',
) {

  case $::lsbdistcodename {
    precise: {
      package{ 'python-ipaddr':
        ensure => present,
      }
    }
    default: {
      ::python::pip { $pip_name:
        ensure     => $ensure,
        virtualenv => $virtualenv,
        owner      => $owner,
        require    => Class['twitch_python::pip::install'],
      }
    }
  }
}
