class twitch_python::pip::pynetlinux (
  $pip_name   = 'pynetlinux',
  $ensure     = '1.1',
  $virtualenv = 'system',
  $owner      = 'root',
) {
  ::python::pip { $pip_name:
    ensure     => $ensure,
    virtualenv => $virtualenv,
    owner      => $owner,
  }
  if $::cmdline['boot'] != 'live' {
    ::python::pip[$pip_name] {
      require => Class['twitch_python::pip::install']
    }
  }
}
