class twitch_python::pip::twisted (
  $pip_name   = 'Twisted',
  $ensure     = '12.2.0',
  $virtualenv = 'system',
  $owner      = 'root',
) {

  $twisted_apt_packages = [
    'python-twisted',
    'python-twisted-bin',
    'python-twisted-conch',
    'python-twisted-core',
    'python-twisted-lore',
    'python-twisted-mail',
    'python-twisted-names',
    'python-twisted-news',
    'python-twisted-runner',
    'python-twisted-web',
    'python-twisted-words',
  ]

  package{ $twisted_apt_packages:
    ensure => purged,
    before => Python::Pip[$pip_name],
  }

  ::python::pip { $pip_name:
    ensure     => $ensure,
    virtualenv => $virtualenv,
    owner      => $owner,
    require    => Class['twitch_python::pip::install'],
  }
}
