# Sets up configs for r10k and the webhook
class twitch_r10k::config (
  $sources_config_hash,
  $r10k_config_file,
  $github_webhook_priv_key = $twitch_r10k::params::webhook_github_priv_key,
  $github_webhook_pub_key  = $twitch_r10k::params::webhook_github_pub_key,
) inherits twitch_r10k::params {

  validate_hash($sources_config_hash)
  validate_string($r10k_config_file, $github_webhook_priv_key, $github_webhook_pub_key)

  file { 'r10k_config':
    ensure  => 'file',
    path    => $r10k_config_file,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    content => template('twitch_r10k/r10k.yaml.erb'),
  }

  file { ['/etc/r10k_webhook', $cache_dir]:
    ensure => 'directory',
    owner  => 'puppet',
    group  => 'root',
    mode   => '0750',
  }

  file { '/var/lib/puppet/.ssh':
    ensure  => 'directory',
    owner   => 'puppet',
    group   => 'puppet',
    mode    => '0700',
    require => Class['::twitch_puppet::master'],
  }

  # This key is for checking out the repo from git when an update is received
  $puppet_keyfile = '/var/lib/puppet/.ssh/id_rsa'

  twitch_sandstorm_agent::template { 'webhook-ssh-key-priv':
    destination => $puppet_keyfile,
    key         => $github_webhook_priv_key,
    mode        => '0600',
    owner       => 'puppet',
    group       => 'puppet',
    require     => File['/var/lib/puppet/.ssh'],
  }

  twitch_sandstorm_agent::template { 'webhook-ssh-key-pub':
    destination => "${puppet_keyfile}.pub",
    key         => $github_webhook_pub_key,
    mode        => '0644',
    owner       => 'puppet',
    group       => 'puppet',
    require     => File['/var/lib/puppet/.ssh'],
  }

  twitch_sandstorm_agent::template { 'r10k_webhook_github_token':
    destination => '/etc/r10k_webhook/github_token',
    mode        => '0400',
    owner       => 'root',
    group       => 'root',
    key         => 'video-ops/puppet/production/r10k-webhook-github-token',
    notify      => Exec['register_r10k_webhook'],
    require     => File['/etc/r10k_webhook'],
  }

  exec { 'register_r10k_webhook':
    command     => '/usr/local/bin/github_webhook_register.sh',
    require     => [
      Package['twitch-r10k-webhook-utils'],
      Twitch_sandstorm_agent::Template['r10k_webhook_github_token'],
    ],
    refreshonly => true,
  }

  file { '/var/run/twitch-r10k-webhook-receiver.pid':
    ensure => 'file',
    owner  => 'puppet',
    group  => 'puppet',
    mode   => '0644',
  }

}
