## This is a profile class to setup r10k on puppet masters
## for use with video-puppet r10k setup
class twitch_r10k (
  $sources_config_hash       = $twitch_r10k::params::sources_config_hash,
  $webhook_listen            = $twitch_r10k::params::webhook_listen,
  $webhook_loglevel          = $twitch_r10k::params::webhook_loglevel,
  $r10k_config_file          = $twitch_r10k::params::r10k_config_file,
  $r10k_bin_file             = $twitch_r10k::params::r10k_bin_file,
  $r10k_poolsize             = $twitch_r10k::params::r10k_poolsize,
  $r10k_ensure               = $twitch_r10k::params::r10k_ensure,
  $cri_ensure                = $twitch_r10k::params::cri_ensure,
  $r10k_webhook_utils_ensure = $twitch_r10k::params::r10k_webhook_utils_ensure,
) inherits twitch_r10k::params {

  validate_hash($sources_config_hash)
  validate_string($r10k_config_file, $r10k_bin_file, $webhook_loglevel, $webhook_listen, $r10k_ensure, $cri_ensure, $r10k_webhook_utils_ensure)

  class { '::twitch_r10k::config':
    sources_config_hash => $sources_config_hash,
    r10k_config_file    => $r10k_config_file,
  }

  package { 'cri':
    ensure   => $cri_ensure,
    provider => 'gem',
  }

  package { 'r10k':
    ensure   => $r10k_ensure,
    provider => 'gem',
    require  => Package['cri'],
  }

  file { 'twitch_r10k_webhook_receiver.py':
    ensure  => 'file',
    path    => '/usr/local/bin/twitch_r10k_webhook_receiver.py',
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    content => template('twitch_r10k/twitch_r10k_webhook_receiver.py.erb'),
  }

  ::twitch_systemd::service { 'twitch-r10k-webhook':
    command   => '/usr/bin/python3 /usr/local/bin/twitch_r10k_webhook_receiver.py',
    user      => 'puppet',
    enable    => true,
    timeout   => 30,
    killmode  => 'process',
    after     => ['rsyslog.service', 'network.target'],
    require   => [
      File['twitch_r10k_webhook_receiver.py'],
      Class['twitch_r10k::config'],
      Package['r10k'],
    ],
    subscribe => File['twitch_r10k_webhook_receiver.py'],
    restart   => 'always',
  }

  package { 'twitch-r10k-webhook-utils':
    ensure   => $r10k_webhook_utils_ensure,
    provider => 'apt',
    notify   => Exec['register_r10k_webhook'],
    require  => File['twitch_r10k_webhook_receiver.py'],
  }

}
