## Params for r10k and its webhook classes
class twitch_r10k::params {
  $r10k_config_file              = '/etc/r10k.yaml'
  $r10k_bin_file                 = '/usr/local/bin/r10k'
  $cache_dir                     = '/etc/puppet/r10kcache'
  $webhook_github_priv_key       = 'video-ops/puppet/production/webhook-video-puppet-key'
  $webhook_github_pub_key        = 'video-ops/puppet/production/webhook-video-puppet-pub'
  $webhook_listen                = '8090'
  $webhook_loglevel              = 'INFO'
  $r10k_poolsize                 = '20'
  $r10k_ensure                   = '3.7.0'
  $cri_ensure                    = '2.15.10'
  $r10k_webhook_utils_pkg_ensure = '1.0.2'
  $sources_config_hash           = {
    'vidcs_control_repo'   => {
      'remote'                 => 'git@git.xarth.tv:video-puppet/control-repo.git',
      'basedir'                => '/etc/puppet/environments',
      'invalid_branches'       => 'error',
      'branch_filter'          => '^\W+$',
      'ignore_branch_prefixes' => 'puppet5_',
    },
  }
}
