class twitch_rabbitmq::monitoring () {

  file { '/var/lib/nagios/check_rabbit.py':
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    source  => "puppet:///modules/twitch_rabbitmq/check_rabbit.py",
  }

  file { '/var/lib/nagios/rabbit.py':
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0755',
    source  => "puppet:///modules/twitch_rabbitmq/rabbit.py",
  }

  file { '/var/lib/nagios/rabbit_queues.conf':
    ensure  => present,
    owner   => 'root',
    group   => 'root',
    mode    => '0644',
    source  => "puppet:///modules/twitch_rabbitmq/rabbit_queues.conf",
  }

  ::nrpe::command { 'check_rabbit_rails':
    ensure  => 'present',
    command => "/var/lib/nagios/check_rabbit.py --url http://localhost:15672/api/ --config /var/lib/nagios/rabbit_queues.conf --message rails"
  }

  ::nrpe::command { 'check_rabbit_rails_dev':
    ensure  => 'present',
    command => "/var/lib/nagios/check_rabbit.py --url http://localhost:15672/api/ --config /var/lib/nagios/rabbit_queues.conf --message rails_dev"
  }

  ::nrpe::command { 'check_rabbit_rails_staging':
    ensure  => 'present',
    command => "/var/lib/nagios/check_rabbit.py --url http://localhost:15672/api/ --config /var/lib/nagios/rabbit_queues.conf --message rails_staging"
  }

  ::nrpe::command { 'check_rabbit_rails_app':
    ensure  => 'present',
    command => "/var/lib/nagios/check_rabbit.py --url http://localhost:15672/api/ --config /var/lib/nagios/rabbit_queues.conf --message rails_workers_app"
  }

   ::nrpe::command { 'check_rabbit_rails_email':
     ensure  => 'present',
     command => "/var/lib/nagios/check_rabbit.py --url http://localhost:15672/api/ --config /var/lib/nagios/rabbit_queues.conf --message rails_workers_email"
  }

}
