class twitch_rabbitmq::params {
  $consul_service_name       = "rabbitmq-${cluster}"
  $consul_service_tags       = [
    $facts['rabbitmq_version'],
    pick($::twitch_environment, $twitch_environment, 'staging'),
  ]
  $rabbitmq_secret_file      = '/etc/facter/facts.d/jtvtwchmq_pass.txt'
  $rabbitmq_config_variables = {
    'disk_free_limit'                       => '"50GB"',
    'vm_memory_high_watermark'              => '0.8',
    'vm_memory_high_watermark_paging_ratio' => '0.75',
  }

  case $facts['lsbdistcodename'] {
    'xenial': {
      $erlang_version       = '1:21.1-1'
      $rabbitmq_pkg_version = '3.7.8-1'    # XXX: rabbitmq module creates a fact called rabbitmq_version
    }
    default: { fail("OS Not Supported") }
  }
}
