class twitch_rabbitmq::rails () {
  include twitch_rabbitmq::monitoring

  rabbitmq_vhost { 'web-production':
    ensure => present,
  }
  rabbitmq_vhost { 'web-beta':
    ensure => present,
  }
  rabbitmq_user {'guest':
    ensure => absent,
  }
  rabbitmq_user {'twitch':
    password => 'snwrapoYkjPaFf3XPmKzT4wp',
    admin    => true,
  }
  rabbitmq_user {'web-production_01':
    password => 'ogPbcybkg4QPTaDo4bzcsYEv',
  }
  rabbitmq_user_permissions{ 'twitch@/':
    configure_permission => '.*',
    read_permission      => '.*',
    write_permission     => '.*',
  }
  rabbitmq_user_permissions{ 'nagios@web-production':
    configure_permission => '',
    read_permission      => '.*',
    write_permission     => '',
  }
  rabbitmq_user_permissions{ 'nagios@web-beta':
    configure_permission => '',
    read_permission      => '.*',
    write_permission     => '',
  }
  rabbitmq_user_permissions{ 'web-production_01@web-production':
    configure_permission => '.*',
    read_permission      => '.*',
    write_permission     => '.*',
  }
  rabbitmq_policy{ 'ha-all@web-production':
    pattern    => '.*',
    priority   => 0,
    applyto    => 'all',
    definition => {
      'ha-mode'      => 'all',
      'ha-sync-mode' => 'automatic',
    },
  }
  rabbitmq_policy{ 'ha-all@web-beta':
    pattern    => '.*',
    priority   => 0,
    applyto    => 'all',
    definition => {
      'ha-mode'      => 'all',
      'ha-sync-mode' => 'automatic',
    },
  }
}
